﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// espace de nom des librairies nécessaire aux sockets TCP/IP

using System.Net.Sockets;


namespace TCPClient
{
    class Program
    {
        static void Main(string[] args)
        {
            // une seule méthode in fine qui envoie le message <message> sur un serveur TCP/IP donné d'adresse <serveur> et sur le port <port>
            // le message de retour est affiché 
            Connect("localhost", 13000, "test \n");
        }

        
        static void Connect(String server, Int32 port, String message)
        {
            try
            {
                // Créé un TcpClient.
                // Ce client ne marchera que si vous avez un serveur TCP/IP en attente de connection sur server:port

                TcpClient client = new TcpClient(server, port);

                // Traduit le message passé en ASCII et l'enregistre comme un tableau d'octets.
                Byte[] data = System.Text.Encoding.ASCII.GetBytes(message);

                // associé un flux de client pour la lecture et l'écriture.

                NetworkStream stream = client.GetStream();

                // Envoie le message au serveur TCP connecté.
                stream.Write(data, 0, data.Length);

                Console.WriteLine("Sent: {0}", message);

                // Reçoit la réponse TcpServer.response.

                // Buffer pour stocker les octets de réponse.
                data = new Byte[256];

                // String pour stocker la  réponse ASCII.
                String responseData = String.Empty;

                // Lire le premier lot des octets de la réponse tcpserver.
                Int32 bytes = stream.Read(data, 0, data.Length);
                responseData = System.Text.Encoding.ASCII.GetString(data, 0, bytes);
                Console.WriteLine("Received: {0}", responseData);

                // Ferme le flus et le socket TCPClient
                stream.Close();
                client.Close();
            }


            // Gestion des différentes erreurs qui peuvent survenir 

            catch (ArgumentNullException e)
            {
                Console.WriteLine("ArgumentNullException: {0}", e);
            }
            catch (SocketException e)
            {
                Console.WriteLine("SocketException: {0}", e);
            }

            Console.WriteLine("\n Press Enter to continue...");
            Console.Read();
        }
    }
}
